unit uLockHook;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

const
  WH_KEYBOARD_LL       =  $000D;
  LLKHF_EXTENDED       =  $0001;
  LLKHF_INJECTED       =  $0010;
  LLKHF_ALTDOWN        =  $0020;
  LLKHF_UP             =  $0080;

type
  tagKBDLLHOOKSTRUCT =  packed record
    vkCode :            DWORD;
    scanCode :          DWORD;
    flags :             DWORD;
    time :              DWORD;
    dwExtraInfo :       Integer;
  end;
  KBDLLHOOKSTRUCT      =  tagKBDLLHOOKSTRUCT;
  PKBDLLHOOKSTRUCT     =  ^KBDLLHOOKSTRUCT;
  
var
  hkHook : HHook;
  function LowLevelKeyboardProc(nCode: Integer; wParam: Integer; lParam: Integer): Integer; stdcall; export;
  procedure HookIt;
  procedure UnHookIt;

implementation

procedure HookIt;
begin
  hkHook := SetWindowsHookEx(WH_KEYBOARD_LL,@LowLevelKeyboardProc,hInstance,0);
end;

procedure UnHookIt;
begin
  UnHookWindowsHookEx(hkHook);
end;

function LowLevelKeyboardProc(nCode: Integer; wParam: Integer; lParam: Integer): Integer; stdcall; export;
var  
  Hook : PKBDLLHOOKSTRUCT;
  bControlKeyDown : Boolean;
begin
  Hook := Pointer(lParam);
  Case nCode Of
     HC_ACTION:
      begin
      bControlKeyDown := ((GetAsyncKeyState(VK_CONTROL) SHR ((Sizeof(SHORT) * 8) - 1)) <> 0);
      //Disable CTRL+ESC
      If (Hook^.vkCode = VK_ESCAPE) And (bControlKeyDown) Then
        begin
        Result:=1;
      end
      //Disable ALT+TAB
      Else If ((Hook^.flags And LLKHF_ALTDOWN) <> 0) And (Hook^.vkCode = VK_TAB) Then
        begin
        Result:=1;
      end
      //Disable ALT+ESC
      Else If ((Hook^.flags And LLKHF_ALTDOWN) <> 0) And (Hook^.vkCode = VK_ESCAPE) Then
        begin
        Result:=1;
      end
      //Disable CTRL+ENTER
      Else If (Hook^.vkCode = VK_RETURN) And (bControlKeyDown) Then
        begin
        Result := 1;
      end
      //Disable Windows Key
      Else If (Hook^.vkCode = VK_LWIN) Or (Hook^.vkCode = VK_RWIN) Then
        begin
        Result := 1;
      end
      //Disable All ALT Keys
      Else If (Hook^.vkCode = VK_MENU) Or (Hook^.vkCode = VK_LMENU) Or (Hook^.vkCode = VK_RMENU) Then
        begin
        Result := 1;
      end
      Else      
        begin
        Result := CallNextHookEx(hkHook,nCode,wParam,lParam);
      end;
    end;
    Else
      begin
      Result := CallNextHookEx(hkHook,nCode,wParam,lParam);
    end;
  end;
end;

end.
 