unit Unit1;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.ExtCtrls, Vcl.Menus, CoolTrayIcon, Registry,
  Vcl.ActnList;

type

 PDEV_BROADCAST_HDR = ^TDEV_BROADCAST_HDR;
 TDEV_BROADCAST_HDR = packed record
   dbch_size : DWORD;
   dbch_devicetype : DWORD;
   dbch_reserved : DWORD;
  end;

  PDEV_BROADCAST_VOLUME = ^TDEV_BROADCAST_VOLUME;
  TDEV_BROADCAST_VOLUME = packed record
   dbcv_size : DWORD;
   dbcv_devicetype : DWORD;
   dbcv_reserved : DWORD;
   dbcv_unitmask : DWORD;
   dbcv_flags : WORD;
  end;

  TForm1 = class(TForm)
    Image1: TImage;
    PopupMenu1: TPopupMenu;
    Lockthehouse1: TMenuItem;
    Exit1: TMenuItem;
    CoolTrayIcon1: TCoolTrayIcon;
    procedure FormCreate(Sender: TObject);
    procedure Image1Click(Sender: TObject);
    procedure Lockthehouse1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure CoolTrayIcon1DblClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
    Function  LockEverything: boolean;
    procedure WMDEVICECHANGE(var Msg: TMessage); message WM_DEVICECHANGE;
    Procedure WMHotkey( Var msg: TWMHotkey ) ;   message WM_HOTKEY;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  GetLetter : string;
  b : TBitmap;
  CloseMe : Boolean;
  unlockkey : string;

implementation

uses uLockHook, uLogin;

{$R *.dfm}

procedure ScreenShot(DestBitmap : TBitmap) ;
var
  DC : HDC;
begin
  DC := GetDC (GetDesktopWindow) ;
  try
   DestBitmap.Width := GetDeviceCaps (DC, HORZRES) ;
   DestBitmap.Height := GetDeviceCaps (DC, VERTRES) ;
   BitBlt(DestBitmap.Canvas.Handle, 0, 0, DestBitmap.Width, DestBitmap.Height, DC, 0, 0, SRCCOPY) ;
  finally
   ReleaseDC (GetDesktopWindow, DC) ;
  end;
end;

procedure TForm1.CoolTrayIcon1DblClick(Sender: TObject);
begin
    LockEverything;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Application.Terminate;
end;


Procedure TForm1.WMHotkey( Var msg: TWMHotkey ) ;
   Begin
     If msg.hotkey = 1 Then Begin
         If IsIconic( Application.Handle ) Then
           Application.Restore;
         BringToFront;
     End;
   End;


procedure EnableTaskMan(Enable: Boolean);
const
  sRegPolicies = '\Software\Microsoft\Windows\CurrentVersion\Policies';
begin
 With TRegistry.Create Do
  Try
    RootKey := HKEY_CURRENT_USER;
    If OpenKey(sRegPolicies + '\System\',True) Then
      begin
      Case Enable Of
        False: WriteInteger('DisableTaskMgr',1);
        True: WriteInteger('DisableTaskMgr',0);
      end;
    end;
    CloseKey;
    If OpenKey(sRegPolicies + '\Explorer\',True) Then
      begin
      Case Enable of
        False:
          begin
          WriteInteger('NoChangeStartMenu',1);
          WriteInteger('NoClose',1);
          WriteInteger('NoLogOff',1);
        end;
        True:
          begin
          WriteInteger('NoChangeStartMenu',0);
          WriteInteger('NoClose',0);
          WriteInteger('NoLogOff',0);
        end;
      end;
    end;
  CloseKey;
  Finally
    Free;
  end;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    UnRegisterHotkey( Handle, 1 ) ;
    b.FreeImage;
    FreeAndNil(b);
    EnableTaskMan(True);
    UnhookIt;
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
   CanClose := CloseMe;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin

unlockkey := LowerCase(ParamStr(1));

CloseMe := False;

If not RegisterHotkey
    (Handle, 1, MOD_ALT or MOD_SHIFT, VK_F9) Then
     ShowMessage('Unable to assign Alt-Shift-F9 as hotkey.') ;

     b := TBitmap.Create;
     ScreenShot(b) ;
     Image1.Picture.Bitmap.Assign(b) ;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  Form1.Height := Screen.Height;
  Form1.Width := Screen.Width;
try
  ScreenShot(b) ;
  Image1.Picture.Bitmap.Assign(b) ;
  SetForegroundWindow(Handle);
  SetActiveWindow(Application.Handle);

  EnableTaskMan(False);
  DoubleBuffered := True;
  HookIt;

except
    //
end;
end;

Function TForm1.LockEverything: boolean;
begin
  If IsIconic( Application.Handle ) Then
    Application.Restore;
  BringToFront;
end;

procedure TForm1.Image1Click(Sender: TObject);
begin
    LoginForm.Show;
end;

procedure TForm1.Lockthehouse1Click(Sender: TObject);
begin
   LockEverything;
end;


procedure TForm1.WMDeviceChange(var Msg: TMessage);
var
    VolName, FileSysName : Array[0..Max_Path]Of Char;
    VolSerial, FileMaxLen, FileFlags : DWord;
    S : string;
begin
  if Msg.wParam =$8000 then begin
          if PDEV_BROADCAST_HDR( Msg.LParam )^.dbch_devicetype <>2 then exit;
          if PDEV_BROADCAST_VOLUME( Msg.LParam )^.dbcv_flags <>0 then exit;

        S := 'Connection du priphrique !' +#13+#10+#13+#10;
  str(ln(PDEV_BROADCAST_VOLUME( Msg.LParam )^.dbcv_unitmask)/ln(2)+Ord('A'):2:0,GetLetter);
        S := S + 'DeviceID :'+#9+#9+ char(strtoint(GetLetter)) + ':\' + #13+#10;
   If GetVolumeInformation(pchar(char(strtoint(GetLetter))+':\'),VolName,Max_Path,@VolSerial,
             FileMaxLen, FileFlags,FileSysName,Max_Path)
    Then
    begin

    //Showmessage(unlockkey + ' ' + IntToStr(VolSerial));

   if '-'+LowerCase(inttohex(VolSerial, 8)) = LowerCase(unlockkey) then
      begin
        UnHookIt;
        EnableTaskMan(True);

        CoolTrayIcon1.MinimizeToTray := True;
        Application.Minimize;
        CloseMe := True;
        Close;
      end;
      end;
      end;

  if Msg.wParam =$8004 then begin
          if PDEV_BROADCAST_HDR( Msg.LParam )^.dbch_devicetype <>2 then exit;
          if PDEV_BROADCAST_VOLUME( Msg.LParam )^.dbcv_flags <>0 then exit;

        S := 'Dconnection du priphrique !' +#13+#10+#13+#10;
  str(ln(PDEV_BROADCAST_VOLUME( Msg.LParam )^.dbcv_unitmask)/ln(2)+Ord('A'):2:0,GetLetter);
        beep;
  end;

end;

end.
